/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.LOTRAchievement;
import lotr.common.LOTRFoods;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.entity.npc.LOTREntityNearHaradrim;
import lotr.common.entity.npc.LOTRTradeEntries;
import lotr.common.entity.npc.LOTRTradeable;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class LOTREntitySouthronBartender
extends LOTREntityNearHaradrim
implements LOTRTradeable.Bartender {
    public LOTREntitySouthronBartender(World world) {
        super(world);
        this.addTargetTasks(false);
        this.npcLocationName = "entity.lotr.SouthronBartender.locationName";
    }

    @Override
    public LOTRTradeEntries getBuyPool() {
        return LOTRTradeEntries.SOUTHRON_BARTENDER_BUY;
    }

    @Override
    public LOTRTradeEntries getSellPool() {
        return LOTRTradeEntries.SOUTHRON_BARTENDER_SELL;
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        data = super.func_110161_a(data);
        this.npcItemsInv.setIdleItem(new ItemStack(LOTRMod.gobletCopper));
        return data;
    }

    @Override
    public void func_70628_a(boolean flag, int i) {
        super.func_70628_a(flag, i);
        int drinks = 1 + this.field_70146_Z.nextInt(4) + i;
        for (int l = 0; l < drinks; ++l) {
            ItemStack drink = LOTRFoods.SOUTHRON_DRINK.getRandomFood(this.field_70146_Z);
            this.func_70099_a(drink, 0.0f);
        }
    }

    @Override
    public float getAlignmentBonus() {
        return 2.0f;
    }

    @Override
    public boolean canTradeWith(EntityPlayer entityplayer) {
        return this.isFriendly(entityplayer);
    }

    @Override
    public void onPlayerTrade(EntityPlayer entityplayer, LOTRTradeEntries.TradeType type, ItemStack itemstack) {
        LOTRLevelData.getData(entityplayer).addAchievement(LOTRAchievement.tradeHaradBartender);
    }

    @Override
    public boolean shouldTraderRespawn() {
        return true;
    }

    @Override
    public String getSpeechBank(EntityPlayer entityplayer) {
        if (this.isFriendlyAndAligned(entityplayer)) {
            return "nearHarad/coast/bartender/friendly";
        }
        return "nearHarad/coast/bartender/hostile";
    }
}

